/*******************************************************************************
This code replicates Figure 15: International Transmision of FED Hikes: The Role of Balance Sheet 
Weakness with Global Controls (GK surprises)

For confidentiality issues, we can't provide UIP nor FX debt data. Hence, we provide 
the code even it can't be run. We provide the LPs results in excel files.

*******************************************************************************/

clear
set more off
cls
clear matrix
clear mata 
set maxvar 8000
set graphics on
//Change this directory depending who is running the code
cap cd "Replication_pkg/Data_programs/Data"  

use "LP_data", clear
*****************
//Drop covid 
******************
drop if time_q>tq(2019q4) 

/*******************************************************************************+
Relevant FX measures: First year available
*******************************************************************************/
//First year available of FX debt
sort IFS_code time_q 
bys IFS_code (time_q): gen long obsno = _n
by IFS_code (time_q) : gen countnonmissing = sum(!missing(FX_debt_f)) if !missing(FX_debt_f)
bysort IFS_code (countnonmissing) : gen fx_debt_first = FX_debt_f[1]
format fx_debt_first %3.2f
drop obsno countnonmissing 

/*******************************************************************************
Generate groups
*******************************************************************************/
//Updated ER classification
drop if IRR_coarse==1
drop if IRR_coarse==6

/*******************************************************************************
Drop LICS+ 
*******************************************************************************/
drop if IMF_incomeLevel==3
drop if Name=="Bolivia"
drop if Name=="Cambodia"
drop if Name=="Dominican Republic"
drop if Name=="Jamaica"
drop if Name=="Mongolia"
drop if Name=="Nicaragua"


/*******************************************************************************
Global factors 
*******************************************************************************/
//Global dollar shock as in 0Z (2022): 10% size shock 
xtset IFS_code time_q 
g Dollar_shock=ln(aeusd_g)-ln(l.aeusd_g)
replace Dollar_shock=Dollar_shock/0.1 

//Trade balance:
bys time_q EM: egen median_tb=median(trade_balance_GDP)

//Commodity index 
g l_oil=ln(oil_index)

/*******************************************************************************
Set parameters of LP
*******************************************************************************/
global lags=4 
global horizon=10 
global conf=90 //confidence levels 
global cinorm = invnormal($conf/100)
global instrument "ff4"

/*
Get RHS:
1. Lags of dependent variable 
2. Lags of gdp growth and inflation differentials 
3. Lags of the shockvar 
4. Lags of the instrument
*/
xtset IFS_code time_q 
g lcpi=ln(cpi_IFS)
g inflationIFS=D.lcpi //inflation q to q 

//winsor inflation ONLY:
winsor2 inflationIFS, replace cuts(4 96)

g ler=ln(ER_avg_IFS) 
g g_er=D.ler //ER q to q
g lgdp=ln(rGDPsa_weo)



foreach var of varlist g_gdp_final inflationIFS {
	g double var1=`var' if IFS_code==111
	bys time_q: egen double max=max(var1) 
	g double `var'_diff=`var'-max 
	drop var1 max 
	}


xtset IFS_code time_q 
//Lags 
foreach var of varlist g_gdp_final lgdp inflationIFS lcpi g_gdp_final_diff inflationIFS_diff i_treasury_12m_avg_US g_er all_DB_inflow_AHKS_GDP_2023 i_policy_US $instrument Dollar_shock median_tb l_oil { 
	forv l=1/$lags { 
		g `var'_l`l'=l`l'.`var'

	}
}
/*
Get the LHS: 
*/	
//Leads 
foreach var of varlist g_gdp_final lgdp inflationIFS lcpi g_er all_DB_inflow_AHKS_GDP_2023 i_policy_US { 
	forv h=0/$horizon{ 
		g `var'_`h'=f`h'.`var'
		
	}	
}

// Time span: 
keep if time_q>=tq(1990q1) 

/*******************************************************************************
LP IV regression
*******************************************************************************/
cd "../../Figures/Figure 15"
global x "*g_gdp_final_diff_l* *inflationIFS_diff_l* *i_treasury_12m_avg_US_l* ${instrument}_l* Dollar_shock median_tb l_oil" //Define main controls 


//keep FX debt countries only! 
keep if fx_sample==1
		
xtset IFS_code time_q 
global int "fx_debt_first"
sum $int , d 
global min=r(min)
global max=r(max)  

global colorHigh  "blue"
global colorLow  "red"

/*
Obtain coefficient to normalize 
*/

ivreghdfe i_policy_US_0 i_policy_US_l1-i_policy_US_l4 $x (i_treasury_12m_avg_US=${instrument}), absorb(IFS_code) /*first bw(`neweylag') level(90)*/
global b_norm=_b[i_treasury_12m_avg_US]


/*
GDP levels
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1


	ivreghdfe lgdp_`h' *lgdp_l* $x ///
	(i_treasury_12m_avg_US c.${int}#c.i_treasury_12m_avg_US=${instrument} c.${int}#c.${instrument}), absorb(IFS_code) first bw(`neweylag') level(90)
	
	margins, dydx(i_treasury_12m_avg_US) at(${int}=($min $max)) level(90) force post
	mat B=e(b) //1X2 matrix. Element (1,1) is the marginal effect at max/min 
	mat V=e(V) //2x2 matrix. We need the elements of the diagonal
	//Low
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=B[1,1]/${b_norm}
	mat coef[`j',4]=(B[1,1]+${cinorm}*V[1,1]^(1/2))/${b_norm} 
	mat coef[`j',5]=(B[1,1]-${cinorm}*V[1,1]^(1/2))/${b_norm} 
	
	//High
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=B[1,2]/${b_norm}/${b_norm}
	mat coefAE[`j',4]=(B[1,2]+${cinorm}*V[2,2]^(1/2))/${b_norm}
	mat coefAE[`j',5]=(B[1,2]-${cinorm}*V[2,2]^(1/2))/${b_norm}
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
*putexcel set "$excelfile", modify sheet("gdp-EM", replace)
*putexcel A1=matrix(coef)
*putexcel clear 
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Low FX debt}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", orientation(vertical) size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) name(lgdp_EM,replace)
graph save "lgdpLow.gph", replace

cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf: High FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", orientation(vertical) size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "lgdpHigh.gph", replace
graph combine "lgdpLow.gph" "lgdpHigh.gph", cols(2) title("{bf:GDP}", size(vlarge))  ycom
graph export "lGDP.pdf", replace
rm "lgdpLow.gph"
rm "lgdpHigh.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 15.xlsx", sheet("GDP", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb

/*
ln(CPI)
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	
	ivreghdfe lcpi_`h' *lcpi_l* $x ///
	(i_treasury_12m_avg_US c.${int}#c.i_treasury_12m_avg_US=${instrument} c.${int}#c.${instrument}), absorb(IFS_code) first bw(`neweylag') level(90)
	
	margins, dydx(i_treasury_12m_avg_US) at(${int}=($min $max)) level(90) force post
	mat B=e(b) //1X2 matrix. Element (1,1) is the marginal effect at max/min 
	mat V=e(V) //2x2 matrix. We need the elements of the diagonal
	//Low
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=B[1,1]/${b_norm}
	mat coef[`j',4]=(B[1,1]+${cinorm}*V[1,1]^(1/2))/${b_norm} 
	mat coef[`j',5]=(B[1,1]-${cinorm}*V[1,1]^(1/2))/${b_norm} 
	
	//High
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=B[1,2]/${b_norm}/${b_norm}
	mat coefAE[`j',4]=(B[1,2]+${cinorm}*V[2,2]^(1/2))/${b_norm}
	mat coefAE[`j',5]=(B[1,2]-${cinorm}*V[2,2]^(1/2))/${b_norm}
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
*putexcel set "$excelfile", modify sheet("inflation-EM", replace)
*putexcel A1=matrix(coef)
*putexcel clear
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Low FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "lcpi_Low.gph"
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf: High FX debt}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("% change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "lcpi_High.gph"

graph combine "lcpi_Low.gph" "lcpi_High.gph", title("{bf:CPI}", size(vlarge))  ycom
graph export "lcpi.pdf", replace
rm "lcpi_Low.gph"
rm "lcpi_High.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 15.xlsx", sheet("CPI", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb


/*
Exchange rate q/q growth
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	//EM 
	ivreghdfe g_er_`h' *g_er_l* $x ///
	(i_treasury_12m_avg_US c.${int}#c.i_treasury_12m_avg_US=${instrument} c.${int}#c.${instrument}), absorb(IFS_code) first bw(`neweylag') level(90)
	
	margins, dydx(i_treasury_12m_avg_US) at(${int}=($min $max)) level(90) force post
	mat B=e(b) //1X2 matrix. Element (1,1) is the marginal effect at max/min 
	mat V=e(V) //2x2 matrix. We need the elements of the diagonal
	//Low
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=B[1,1]/${b_norm}
	mat coef[`j',4]=(B[1,1]+${cinorm}*V[1,1]^(1/2))/${b_norm} 
	mat coef[`j',5]=(B[1,1]-${cinorm}*V[1,1]^(1/2))/${b_norm} 
	
	//High
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=B[1,2]/${b_norm}/${b_norm}
	mat coefAE[`j',4]=(B[1,2]+${cinorm}*V[2,2]^(1/2))/${b_norm}
	mat coefAE[`j',5]=(B[1,2]-${cinorm}*V[2,2]^(1/2))/${b_norm}
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
*putexcel set "$excelfile", modify sheet("ER-EM", replace)
*putexcel A1=matrix(coef)
*putexcel clear
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Low FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "g_er_Low.gph", replace 
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf: High FX debt}", size(huge)) xlabel(1(2)10, nogrid  tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "g_er_High.gph", replace 
graph combine "g_er_Low.gph" "g_er_High", title("{bf:Exchange Rate (Local/USD)}", size(vlarge)) ycom
graph export "g_er.pdf", replace
rm "g_er_Low.gph"
rm "g_er_High.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 15.xlsx", sheet("ER", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb


/*
Capital flows to GDP
*/
mat drop _all
mat coef=J($horizon+1,5,.)
mat coefAE=J($horizon+1,5,.)
cap n drop ub lb Quarter coef Zero EM_d
local j=1 
forv h=0/$horizon{
	local neweylag=`h'+1
	
	//EM 
	ivreghdfe all_DB_inflow_AHKS_GDP_2023_`h' *all_DB_inflow_AHKS_GDP_2023_l* $x ///
	(i_treasury_12m_avg_US c.${int}#c.i_treasury_12m_avg_US=${instrument} c.${int}#c.${instrument}), absorb(IFS_code) first bw(`neweylag') level(90)
	
	margins, dydx(i_treasury_12m_avg_US) at(${int}=($min $max)) level(90) force post
	mat B=e(b) //1X2 matrix. Element (1,1) is the marginal effect at max/min 
	mat V=e(V) //2x2 matrix. We need the elements of the diagonal
	//Low
	mat coef[`j',1]=`h' 
	mat coef[`j',2]=1
	mat coef[`j',3]=B[1,1]/${b_norm}
	mat coef[`j',4]=(B[1,1]+${cinorm}*V[1,1]^(1/2))/${b_norm} 
	mat coef[`j',5]=(B[1,1]-${cinorm}*V[1,1]^(1/2))/${b_norm} 
	
	//High
	mat coefAE[`j',1]=`h' 
	mat coefAE[`j',2]=0
	mat coefAE[`j',3]=B[1,2]/${b_norm}/${b_norm}
	mat coefAE[`j',4]=(B[1,2]+${cinorm}*V[2,2]^(1/2))/${b_norm}
	mat coefAE[`j',5]=(B[1,2]-${cinorm}*V[2,2]^(1/2))/${b_norm}
		
	local j=`j'+1
	
}
mat colnames coef="Quarter" "EM_d" "coef" "ub" "lb"
mat colnames coefAE="Quarter" "EM_d" "coef" "ub" "lb"
mat li coef
*putexcel set "$excelfile", modify sheet("capflows-EM", modify)
*putexcel C2=matrix(coef)
*putexcel clear
svmat coef, names(col)
g Zero=0
drop if Quarter==0
set autotabgraphs on 
twoway (line ub Quarter, lcolor("$colorHigh") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorHigh") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorHigh") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf:Low FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
 graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "capflowsLow.gph", replace
cap n drop Quarter EM_d coef ub lb Zero

svmat coefAE, names(col)
g Zero=0
drop if Quarter==0

twoway (line ub Quarter, lcolor("$colorLow") lpattern(dash)) ///
(line lb Quarter, lcolor("$colorLow") lpattern(dash)) /// 
 (line coef Quarter, lcolor("$colorLow") lwidth(thick)) (line Zero Quarter, lcolor(black) lwidth(thick)), ///
legend(off) ylabel(,nogrid tposition(inside) angle(horizontal)) title("{bf: High FX debt}", size(huge)) xlabel(1(2)10, nogrid tposition(inside)) ///
subtitle("`ytitle'", position(11)) xtitle("Quarter", size(large)) ytitle("p.p. change", size(large)) ///
graphregion(color(white)) plotregion(lstyle(solid) lcolor(black) lwidth(medium)) 
graph save "capflowsHigh.gph", replace

graph combine "capflowsLow" "capflowsHigh", title("{bf:Capital Inflows to GDP}", size(vlarge))  ycom
graph export "flows.pdf", replace
rm "capflowsLow.gph"
rm "capflowsHigh.gph"
cap n drop Quarter EM_d coef ub lb Zero

//Save results to excel 
mat A=(coef\coefAE)
svmat A,names(col)
drop if Quarter==0 
export excel Quarter EM_d coef ub lb using "Figure 15.xlsx", sheet("Capflows", replace) firstrow(variables)
cap n drop Quarter EM_d coef ub lb

